import subprocess
import threading
import sys
import time
import queue
import re

ENGINE = ["Absurd-1.0.exe"]

LIMIT_TYPE = "nodes" # choose "nodes" or "depth"
LIMIT_VALUE = 1000
INFO_DELAY = 1.75    # in seconds

info_queue = queue.Queue()

bestmove_buffer = None

engine = subprocess.Popen(
    ENGINE,
    stdin=subprocess.PIPE,
    stdout=subprocess.PIPE,
    text=True,
    bufsize=1
)

# -------- GUI → engine --------
def gui_to_engine():
    global bestmove_buffer

    for line in sys.stdin:
        line = line.strip()

        # reset state for each new move
        if line.startswith("position"):
            bestmove_buffer = None

        # enforce ponder=false
        if line.lower().startswith("setoption name ponder"):
            engine.stdin.write("setoption name Ponder value false\n")
            engine.stdin.flush()
            sys.stdout.write("info Ponder forced to false" + "\n")
            sys.stdout.flush()
            continue

        # replace any go with go chosen limit
        if line.startswith("go"):
            engine.stdin.write(f"go {LIMIT_TYPE} {LIMIT_VALUE}\n")
            engine.stdin.flush()
            sys.stdout.write(f"info go forced to {LIMIT_TYPE} {LIMIT_VALUE}\n")
            sys.stdout.flush()
            continue
       
        engine.stdin.write(line + "\n")
        engine.stdin.flush()

# -------- listening to engine --------
def engine_reader():
    global bestmove_buffer

    for line in engine.stdout:
        line = line.strip()

        if line.startswith("info") and not line.startswith("info string"):
            info_queue.put(line)

        elif line.startswith("bestmove"):
            # store without posting
            bestmove_buffer = line
            # feed the queue with a triggering line
            info_queue.put("info string SW-trigger: best move computed")

        else:
            # uciok, readyok, ...
            sys.stdout.write(line + "\n")
            sys.stdout.flush()

# -------- slowed down info + triggering logic --------
def info_emitter():
    global bestmove_buffer

    while True:
        line = info_queue.get()

        if not line == "info string SW-trigger: best move computed":
           time.sleep(INFO_DELAY)
           sys.stdout.write(line + "\n")
           sys.stdout.flush()

        else:
           sys.stdout.write(bestmove_buffer + "\n")
           sys.stdout.flush()
           bestmove_buffer = None

# -------- Starting up --------
threading.Thread(target=gui_to_engine, daemon=True).start()
threading.Thread(target=engine_reader, daemon=True).start()
info_emitter()